/*
 * @(#)CEREntitySetFigure.java  1.1  2006-02-21
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.cer.diagram;

import ch.hslu.cm.cer.model.CEREntitySet;
import java.io.IOException;
import org.jhotdraw.app.action.ActionUtil;
import ch.hslu.cm.*;
import ch.hslu.cm.simulation.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.undo.*;
import java.beans.*;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.MoveHandle;
import org.jhotdraw.draw.locator.RelativeDecoratorLocator;
import org.jhotdraw.geom.*;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.*;
/**
 * CEREntitySetFigure.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.1 2006-02-21 Support for super-sub-type added.
 * <br>1.0 2006-01-18 Created.
 */
public class CEREntitySetFigure extends TextFigure
        implements DiagramFigure, PropertyChangeListener {
    /**
     * Figure model.
     */
    private CEREntitySet model;
    /**
     * This adapter is used, to connect a TextFigure with the name of
     * the CEREntitySet model.
     */
    private static class NameAdapter extends FigureAdapter {
        private CEREntitySetFigure target;
        public NameAdapter(CEREntitySetFigure target) {
            this.target = target;
        }
    @Override
        public void attributeChanged(final FigureEvent e) {
            if (e.getAttribute().equals(TEXT)) {
                target.model.setName((String) e.getNewValue());
                
                target.fireUndoableEditHappened(new AbstractUndoableEdit() {
                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                        return labels.getString("name");
                    }
    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        target.model.setName((String) e.getOldValue());
                    }
    @Override
                    public void redo() throws CannotUndoException {
                        super.redo();
                        target.model.setName((String) e.getNewValue());
                    }
                });
            }
        }
    }
    private NameAdapter nameAdapter;
    
    private class EntityTypeAction extends AbstractAction {
        private int type;
        public EntityTypeAction(String name, int type) {
            super(name);
            this.type = type;
            putValue(ActionUtil.SELECTED_KEY, model.getType() == type);
            putValue(ActionUtil.BUTTON_GROUP_KEY, model);
        }
    @Override
        public void actionPerformed(ActionEvent event) {
            final int oldValue = model.getType();
            model.setType(type);
            fireUndoableEditHappened(new AbstractUndoableEdit() {
    @Override
                public String getPresentationName() {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                    return labels.getString("entityType");
                }
    @Override
                public void undo() throws CannotUndoException {
                    super.undo();
                    model.setType(oldValue);
                }
    @Override
                public void redo() throws CannotUndoException {
                    super.redo();
                    model.setType(type);
                }
            });
        }
    };
    
    /** Creates a new instance. */
    public CEREntitySetFigure() {
        this(CEREntitySet.TYPE_STRONG);
    }
    public CEREntitySetFigure(int entityType) {
        RectangleFigure decorator = new RectangleFigure();
        STROKE_PLACEMENT.set(decorator, StrokePlacement.OUTSIDE);
        FILL_UNDER_STROKE.set(decorator, AttributeKeys.Underfill.FULL);
        setDecorator(decorator);
        DECORATOR_INSETS.set(this, new Insets2D.Double(6,10,6,10));
        
        FILL_COLOR.set(this, ConceptualERDiagram.ENTITY_SET_FILL_COLOR);
        STROKE_COLOR.set(this, ConceptualERDiagram.ENTITY_SET_STROKE_COLOR);
        TEXT_COLOR.set(this, ConceptualERDiagram.ENTITY_SET_TEXT_COLOR);
        STROKE_WIDTH.set(this, ConceptualERDiagram.DIAGRAM_STROKE_WIDTH);
        
        setEditable(true);
        FONT_BOLD.set(this, true);
        addFigureListener(nameAdapter = new NameAdapter(this));
        
        setModel(createEntitySet(entityType));
        
        setAttributeEnabled(DECORATOR_INSETS, false);
        setAttributeEnabled(STROKE_TYPE, false);
        setAttributeEnabled(STROKE_PLACEMENT, false);
        setAttributeEnabled(FILL_UNDER_STROKE, false);
        setAttributeEnabled(FONT_BOLD, false);
        setAttributeEnabled(FONT_ITALIC, false);
        setAttributeEnabled(FONT_UNDERLINE, false);
    }
    // DRAWING
    protected void drawConnectors(Graphics2D g) {
        CEREntitySetConnector connector = new CEREntitySetConnector(this);
        connector.draw(g);
    }
    // SHAPE AND BOUNDS
    // ATTRIBUTES
    @Override
    public void set(AttributeKey key, Object newValue) {
        super.set(key, newValue);
        if (getDecorator() != null) {
            getDecorator().set(key, newValue);
        }
    }
    // EDITING
    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
                handles.add(new MoveHandle(this, RelativeDecoratorLocator.northEast()));
                handles.add(new MoveHandle(this, RelativeDecoratorLocator.northWest()));
                handles.add(new MoveHandle(this, RelativeDecoratorLocator.southEast()));
                handles.add(new MoveHandle(this, RelativeDecoratorLocator.southWest()));
        }
        return handles;
    }
    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
        
        LinkedList<Action> actions = new LinkedList<Action>();
        Action action;
        
        Figure item;
        
        
        action = new EntityTypeAction(labels.getString("entityTypeStrong"), CEREntitySet.TYPE_STRONG);
        action.putValue(ActionUtil.SUBMENU_KEY, labels.getString("type"));
        actions.add(action);
        
        action = new EntityTypeAction(labels.getString("entityTypeWeak"), CEREntitySet.TYPE_WEAK);
        action.putValue(ActionUtil.SUBMENU_KEY, labels.getString("type"));
        actions.add(action);
        
        /*
        action = new AbstractAction(labels.getString("attributeAdd")) {
            public void actionPerformed(ActionEvent event) {
                CompositeEdit edit = new CompositeEdit(labels.getString("attributeAdd"));
                fireUndoableEditHappened(edit);
                // XXX - Implement me
                
                model.addAttribute(labels.getString("attributeDefaultName"));
                setAttributesVisible(true);
                
                fireUndoableEditHappened(new AbstractUndoableEdit() {
                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                        return labels.getString("entityType");
                    }
                    public void undo() throws CannotUndoException {
                        super.undo();
                        model.removeAttribute(index);
                    }
                    public void redo() throws CannotUndoException {
                        super.redo();
                        model.addAttribute(labels.getString("attributeDefaultName"));
                    }
                });
                fireUndoableEditHappened(edit);
            }
        };
        // action.putValue(ActionUtil.SUBMENU_KEY, labels.getString("attribute"));
        actions.add(action);
        */
        
               /* 
                action = new AbstractAction(labels.getFormatted("attributePrimaryKey", getModel().getAttribute(index).getAttributeName())) {
                    public void actionPerformed(ActionEvent event) {
                        model.getAttribute(index).setPrimaryKey(! model.getAttribute(index).isPrimaryKey());
                        fireUndoableEditHappened(new AbstractUndoableEdit() {
                            public String getPresentationName() {
                                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                                return labels.getString("attributePrimaryKey");
                            }
                            public void undo() throws CannotUndoException {
                                super.undo();
                                model.getAttribute(index).setPrimaryKey(! model.getAttribute(index).isPrimaryKey());
                            }
                            public void redo() throws CannotUndoException {
                                super.redo();
                                model.getAttribute(index).setPrimaryKey(! model.getAttribute(index).isPrimaryKey());
                            }
                        });
                    }
                };
                action.putValue(ActionUtil.SUBMENU_KEY, labels.getFormatted("attributeProperties", attr.getName()));
                action.putValue(ActionUtil.SELECTED_KEY, model.getAttribute(index).isPrimaryKey());
                actions.add(action);
                
                action = new AbstractAction(labels.getFormatted("attributeDiscriminating", getModel().getAttribute(index).getAttributeName())) {
                    public void actionPerformed(ActionEvent event) {
                        model.getAttribute(index).setDiscriminating(! model.getAttribute(index).isDiscriminating());
                        fireUndoableEditHappened(new AbstractUndoableEdit() {
                            public String getPresentationName() {
                                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                                return labels.getString("attributeDiscriminating");
                            }
                            public void undo() throws CannotUndoException {
                                super.undo();
                                model.getAttribute(index).setDiscriminating(! model.getAttribute(index).isDiscriminating());
                            }
                            public void redo() throws CannotUndoException {
                                super.redo();
                                model.getAttribute(index).setDiscriminating(! model.getAttribute(index).isDiscriminating());
                            }
                        });
                    }
                };
                action = new AbstractAction(labels.getFormatted("attributeMultivalued", getModel().getAttribute(index).getAttributeName())) {
                    public void actionPerformed(ActionEvent event) {
                        model.getAttribute(index).setDiscriminating(! model.getAttribute(index).isDiscriminating());
                        fireUndoableEditHappened(new AbstractUndoableEdit() {
                            public String getPresentationName() {
                                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                                return labels.getString("attributeMultivalued");
                            }
                            public void undo() throws CannotUndoException {
                                super.undo();
                                model.getAttribute(index).setMultivalued(! model.getAttribute(index).isMultivalued());
                            }
                            public void redo() throws CannotUndoException {
                                super.redo();
                                model.getAttribute(index).setMultivalued(! model.getAttribute(index).isMultivalued());
                            }
                        });
                    }
                };
                action = new AbstractAction(labels.getFormatted("attributeDerived", getModel().getAttribute(index).getAttributeName())) {
                    public void actionPerformed(ActionEvent event) {
                        model.getAttribute(index).setDiscriminating(! model.getAttribute(index).isDiscriminating());
                        fireUndoableEditHappened(new AbstractUndoableEdit() {
                            public String getPresentationName() {
                                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                                return labels.getString("attributeDerived");
                            }
                            public void undo() throws CannotUndoException {
                                super.undo();
                                model.getAttribute(index).setDerived(! model.getAttribute(index).isDerived());
                            }
                            public void redo() throws CannotUndoException {
                                super.redo();
                                model.getAttribute(index).setDerived(! model.getAttribute(index).isDerived());
                            }
                        });
                    }
                };
                action.putValue(ActionUtil.SUBMENU_KEY, labels.getFormatted("attributeProperties", attr.getName()));
                action.putValue(ActionUtil.SELECTED_KEY, model.getAttribute(index).isDiscriminating());
                actions.add(action);
            }*/
        
        return actions;
    }
    
    // CONNECTING
    public int getConnectionCount() {
        return getModel().getRelationships().size();
    }
    
    public int getConnectionIndex(DiagramFigure f) {
        return getModel().getRelationships().indexOf(f.getModel());
    }
    
    /**
     * Gets a connector for this figure at the given location.
     * A figure can have different connectors at different locations.
     */
   @Override public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        if (contains(p)) {
            return new CEREntitySetConnector(this);
        } else {
            return null;
        }
    }
   @Override public Connector findCompatibleConnector(Connector c, boolean isStart) {
        if (c.getOwner() == this) return c;
        
        return new CEREntitySetConnector(this);
    }
    
    // COMPOSITE FIGURES
    // CLONING
    // EVENT HANDLING
    
    public CEREntitySet getSimulatedEntityType() {
        return (CEREntitySet) getModel();
    }
    
    
    protected CEREntitySet createEntitySet(int entityType) {
        CEREntitySet entity = new CEREntitySet();
        entity.setType(entityType);
        return entity;
    }
    
    public void setModel(CEREntitySet m) {
        willChange();
        if (model != null) {
            model.removePropertyChangeListener(this);
        }
        model = m;
        if (model != null) {
            model.addPropertyChangeListener(this);
            setText(model.getName());
            
            updateDecorator();
        }
        changed();
    }
    
    @Override
    public CEREntitySet getModel() {
        return model;
    }
    
    private Diagram getDiagram() {
        return (Diagram) getDrawing();
    }
    private Simulation getSimulation() {
        return getDiagram().getSimulation();
    }
    
    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if ((drawing instanceof Diagram) && getModel() != null) {
            getSimulation().add(getModel());
        }
    }
    @Override
    public void removeNotify(Drawing drawing) {
        if (getDrawing() != null && getModel() != null) {
            getSimulation().remove(getModel());
        }
        super.removeNotify(drawing);
    }
    
    
    @Override
    public CEREntitySetFigure clone() {
        CEREntitySetFigure that = (CEREntitySetFigure) super.clone();
        that.nameAdapter = new NameAdapter(that);
        that.addFigureListener(that.nameAdapter);
        that.setModel((CEREntitySet) this.model.clone());
        return that;
    }
    
    public SimulatedElement getSimulatedObject() {
        return model;
    }
    
    @Override
    public void read(DOMInput in) throws IOException {
        double x = in.getAttribute("x", 0d);
        double y = in.getAttribute("y", 0d);
        double w = in.getAttribute("w", 0d);
        double h = in.getAttribute("h", 0d);
        setBounds(new Point2D.Double(x,y), new Point2D.Double(x+w,y+h));
        readAttributes(in);
        in.openElement((in.getElementCount("model") == 1) ? "model" : "Model");
        setModel((CEREntitySet) in.readObject(0));
        in.closeElement();
    }
    @Override
    public void write(DOMOutput out) throws IOException {
        Rectangle2D.Double r = getBounds();
        out.addAttribute("x", r.x);
        out.addAttribute("y", r.y);
        writeAttributes(out);
        out.openElement("Model");
        out.writeObject(getModel());
        out.closeElement();
    }
    @Override
    public int getLayer() {
        return ConceptualERDiagram.OBJECT_LAYER;
    }
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        willChange();
        updateDecorator();
        changed();
    }
    
    protected void updateDecorator() {
        RectangleFigure decorator = (RectangleFigure) getDecorator();
        if (model != null && decorator != null) {
            decorator.setAttributeEnabled(STROKE_TYPE, true);
            STROKE_TYPE.set(decorator,
                    model.getType() == CEREntitySet.TYPE_STRONG ?
                        StrokeType.BASIC :
                        StrokeType.DOUBLE
                    );
            decorator.setAttributeEnabled(STROKE_TYPE, false);
            decorator.setAttributeEnabled(STROKE_INNER_WIDTH_FACTOR, true);
            STROKE_INNER_WIDTH_FACTOR.set(decorator, 3d);
            decorator.setAttributeEnabled(STROKE_INNER_WIDTH_FACTOR, false);
        }
    }
}
